<?php
namespace VM\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;
use JMS\Serializer\Annotation\Type;
use JMS\Serializer\Annotation\SerializedName;
use JMS\Serializer\Annotation\Accessor;

/**
 * VM\ApiBundle\Entity\GroupRoundReportCode
 *
 * @ORM\Table(name="group_round_reports_codes")
 * @ORM\Entity()
 * @ExclusionPolicy("all")
 */
class GroupRoundReportCode
{
    /**
     * @var integer $id
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     * @Expose
     * @AnnotationGroups({"list", "teacherReportsList"})
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="round_id", type="integer")
     * @Expose
     * @AnnotationGroups({"list", "teacherReportsList"})
     */
    private $roundId;

    /**
     * @var integer
     *
     * @ORM\Column(name="group_id", type="integer")
     * @Expose
     * @AnnotationGroups({"list", "teacherReportsList"})
     */
    private $groupId;

    /**
     * @var string
     *
     * @ORM\Column(name="code", type="string", length=6, unique=true)
     * @Expose
     * @AnnotationGroups({"list", "teacherReportsList"})
     */
    private $code;

    /**
     * @var boolean
     *
     * @ORM\Column(name="extended", type="boolean")
     * @Expose
     * @AnnotationGroups({"list", "teacherReportsList"})
     */
    private $extended;

    /**
     * @ORM\ManyToOne(targetEntity="Round",inversedBy="groupRoundReportCode")
     * @ORM\JoinColumn(name="round_id", referencedColumnName="id")
     * @Expose
     * @AnnotationGroups({"list", "teacherReportsList"})
     */
    protected $round;

    /**
     * @ORM\ManyToOne(targetEntity="UserGroups",inversedBy="groupRoundReportCode")
     * @ORM\JoinColumn(name="group_id", referencedColumnName="id")
     * @Expose
     * @AnnotationGroups({"list", "teacherReportsList"})
     */
    protected $group;

    /**
     * @var integer
     *
     * @ORM\Column(name="version", type="integer")
     *
     * @Expose
     * @AnnotationGroups({"list", "teacherReportsList"})
     */
    private $version = 1;

    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set roundId
     *
     * @param integer $roundId
     * @return GroupRoundReportCode
     */
    public function setRoundId($roundId)
    {
        $this->roundId = $roundId;

        return $this;
    }

    /**
     * Get roundId
     *
     * @return integer
     */
    public function getRoundId()
    {
        return $this->roundId;
    }

    /**
     * Set groupId
     *
     * @param integer $groupId
     * @return GroupRoundReportCode
     */
    public function setGroupId($groupId)
    {
        $this->groupId = $groupId;

        return $this;
    }

    /**
     * Get groupId
     *
     * @return integer
     */
    public function getGroupId()
    {
        return $this->groupId;
    }

    /**
     * Set code
     *
     * @param string $code
     * @return GroupRoundReportCode
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * Get code
     *
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * Set extended
     *
     * @param boolean $extended
     * @return GroupRoundReportCode
     */
    public function setExtended($extended)
    {
        $this->extended = $extended;

        return $this;
    }

    /**
     * Get extended
     *
     * @return boolean
     */
    public function getExtended()
    {
        return $this->extended;
    }

    /**
     * Set round
     *
     * @param \VM\ApiBundle\Entity\Round $round
     * @return GroupRoundReportCode
     */
    public function setRound(\VM\ApiBundle\Entity\Round $round = null)
    {
        $this->round = $round;

        return $this;
    }

    /**
     * Get round
     *
     * @return \VM\ApiBundle\Entity\Round
     */
    public function getRound()
    {
        return $this->round;
    }

    /**
     * Set group
     *
     * @param \VM\ApiBundle\Entity\UserGroups $group
     * @return GroupRoundReportCode
     */
    public function setGroup(\VM\ApiBundle\Entity\UserGroups $group = null)
    {
        $this->group = $group;

        return $this;
    }

    /**
     * Get group
     *
     * @return \VM\ApiBundle\Entity\UserGroups
     */
    public function getGroup()
    {
        return $this->group;
    }

    /**
     * Set version
     *
     * @param integer $version
     * @return CompanyReport
     */
    public function setVersion($version)
    {
        $this->version = $version;

        return $this;
    }

    /**
     * Get version
     *
     * @return integer
     */
    public function getVersion()
    {
        return $this->version;
    }
}